/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.hsc.common.util.PIUserUtils;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.etc.StringVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PIHMCUserDelete {
    private String m_userName = null;

    private void unregisterAccess() {
        try {
            AcaClient acaClient = new AcaClient(2);
            int n = acaClient.UnregisterUser(this.m_userName);
            if (n != 0) {
                AccUtils.SHOW(acaClient.GetMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void performCommand() throws PIHscClientException, RequiredParameterException {
        String string = "";
        String string2 = "";
        String[] stringArray = new String[]{this.m_userName};
        if (this.m_userName.equals("hscroot")) {
            string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_CANNOT_DELETE");
            throw new RequiredParameterException(string);
        }
        if (AcaUtils.isPermanentUser((String)this.m_userName)) {
            string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "USER_CANNOT_DELETE");
            throw new RequiredParameterException(string);
        }
        String string3 = "";
        StringVector stringVector = PIUserUtils.getUserList();
        if (!PIUserUtils.isHMCUser(this.m_userName)) {
            String[] stringArray2 = new String[]{this.m_userName};
            throw new PIHscClientException("233E", "PIHscCmdLineBundle", "USER_NOT_FOUND", stringArray2, new Throwable());
        }
        string2 = PIUserUtils.buildDeleteCmd(this.m_userName);
        EExecResult eExecResult = EExec.Exec((String)string2);
        PIUserUtils.printExecResult(eExecResult);
        if (eExecResult.rc != 0 && eExecResult.rc != 3072) {
            PIUserUtils.logSysEvent((short)2108, stringArray);
            throw new PIHscClientException("233E", "PIHscCmdLineBundle", "USER_CANNOT_DELETE");
        }
        this.unregisterAccess();
        PIUserUtils.logSysEvent((short)2107, stringArray);
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        String string = null;
        int n = 0;
        this.m_userName = (String)hashMap.get(HMCCommandUtils.USER_NAME_PARAM);
        if (this.m_userName == null) {
            Object[] objectArray = new String[]{HMCCommandUtils.USER_NAME_PARAM};
            string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", null, objectArray);
            throw new RequiredParameterException(string);
        }
        this.m_userName = this.m_userName.trim();
        n = 1;
        if (this.m_userName.equals("root")) {
            string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ERROR_ROOT_USER");
            throw new RequiredParameterException(string);
        }
        HMCCommandUtils.checkParameterCount(hashMap, n);
    }

    public void printHelp() {
        AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "HMCUSER_DELETE_HELP"));
    }

    public int removeUser(String[] stringArray) throws PIHscClientException, RequiredParameterException {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (0 == stringArray.length) {
            this.printHelp();
            return 1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            arrayList.add(string);
            if (!string.equals(HMCCommandUtils.HELP_PARAM)) continue;
            this.printHelp();
            bl = true;
            break;
        }
        if (!bl) {
            HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
            this.mapParameters(hashMap);
            this.performCommand();
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        String string = null;
        try {
            PIHMCUserDelete pIHMCUserDelete = new PIHMCUserDelete();
            int n = pIHMCUserDelete.removeUser(stringArray);
            System.exit(n);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                pIHscClientException.printStackTrace();
            }
            if ((string = pIHscClientException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                Object[] objectArray = new String[]{"-u"};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", null, objectArray);
            }
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
    }
}

